/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.io.InputStream;
import org.basex.io.IO;
import org.basex.io.in.TextInput;
import org.basex.util.TokenBuilder;

public final class NewlineInput
extends TextInput {
    private int next = -2;

    public NewlineInput(InputStream is) throws IOException {
        this(is, null);
    }

    public NewlineInput(InputStream is, String encoding) throws IOException {
        super(is, encoding);
    }

    public NewlineInput(IO in) throws IOException {
        this(in, null);
    }

    public NewlineInput(IO in, String encoding) throws IOException {
        super(in, encoding);
    }

    @Override
    public NewlineInput validate(boolean flag) {
        super.validate(flag);
        return this;
    }

    @Override
    public int read() throws IOException {
        int n = this.next;
        if (n == -2) {
            n = super.read();
        } else {
            this.next = -2;
        }
        if (n != 13) {
            return n;
        }
        n = super.read();
        if (n != 10) {
            this.next = n;
        }
        return 10;
    }

    public String readLine() throws IOException {
        TokenBuilder tb = new TokenBuilder();
        return this.readLine(tb) ? tb.toString() : null;
    }

    public boolean readLine(TokenBuilder tb) throws IOException {
        tb.reset();
        int ch;
        while ((ch = this.read()) != -1) {
            if (ch == 10) {
                return true;
            }
            tb.add(ch);
        }
        return !tb.isEmpty();
    }
}

