/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ann;

import org.basex.query.QueryText;
import org.basex.query.func.FuncDefinition;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.util.Strings;
import org.basex.util.Token;

public enum Annotation {
    PUBLIC("public()", Annotation.params(new AtomType[0]), QueryText.XQ_URI, false),
    PRIVATE("private()", Annotation.params(new AtomType[0]), QueryText.XQ_URI, false),
    UPDATING("updating()", Annotation.params(new AtomType[0]), QueryText.XQ_URI, false),
    _BASEX_LAZY("lazy()", Annotation.params(new AtomType[0]), QueryText.BASEX_URI),
    _BASEX_INLINE("inline([limit])", Annotation.params(AtomType.INTEGER), QueryText.BASEX_URI),
    _BASEX_LOCK("lock(key)", Annotation.params(AtomType.STRING), QueryText.BASEX_URI),
    _INPUT_CSV("csv(options...)", Annotation.params(AtomType.STRING), QueryText.INPUT_URI),
    _INPUT_HTML("html(options...)", Annotation.params(AtomType.STRING), QueryText.INPUT_URI),
    _INPUT_JSON("json(options...)", Annotation.params(AtomType.STRING), QueryText.INPUT_URI),
    _OUTPUT_ALLOW_DUPLICATE_NAMES("allow-duplicate-names(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_BINARY("binary(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_BYTE_ORDER_MARK("byte-order-mark(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_CDATA_SECTION_ELEMENTS("cdata-section-elements(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_CSV("csv(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_DOCTYPE_PUBLIC("doctype-public(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_DOCTYPE_SYSTEM("doctype-system(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_ENCODING("encoding(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_ESCAPE_SOLIDUS("escape-solidus(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_ESCAPE_URI_ATTRIBUTES("escape-uri-attributes(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_HTML_VERSION("html-version(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_INCLUDE_CONTENT_TYPE("include-content-type(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_INDENT("indent(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_INDENT_ATTRIBUTES("indent-attributes(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_INDENTS("indents(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_ITEM_SEPARATOR("item-separator(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_JSON("json(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_JSON_LINES("json-lines(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_JSON_NODE_OUTPUT_METHOD("json-node-output-method(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_LIMIT("limit(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_MEDIA_TYPE("media-type(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_METHOD("method(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_NEWLINE("newline(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_NORMALIZATION_FORM("normalization-form(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_OMIT_XML_DECLARATION("omit-xml-declaration(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_PARAMETER_DOCUMENT("parameter-document(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_STANDALONE("standalone(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_SUPPRESS_INDENTATION("suppress-indentation(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_TABULATOR("tabulator(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_UNDECLARE_PREFIXES("undeclare-prefixes(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_USE_CHARACTER_MAPS("use-character-maps(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _OUTPUT_VERSION("version(value)", Annotation.params(AtomType.STRING), QueryText.OUTPUT_URI),
    _PERM_CHECK("check([path,map])", Annotation.params(AtomType.STRING, AtomType.STRING), QueryText.PERM_URI),
    _PERM_ALLOW("allow(names...)", Annotation.params(AtomType.STRING), QueryText.PERM_URI, false),
    _REST_PATH("path(path)", Annotation.params(AtomType.STRING), QueryText.REST_URI),
    _REST_ERROR("error(codes...)", Annotation.params(AtomType.STRING), QueryText.REST_URI, false),
    _REST_CONSUMES("consumes(types...)", Annotation.params(AtomType.STRING), QueryText.REST_URI, false),
    _REST_PRODUCES("produces(types...)", Annotation.params(AtomType.STRING), QueryText.REST_URI, false),
    _REST_QUERY_PARAM("query-param(name,variable[,defaults...])", Annotation.params(AtomType.STRING, AtomType.STRING, AtomType.ITEM), QueryText.REST_URI, false),
    _REST_FORM_PARAM("form-param(name,variable[,defaults...])", Annotation.params(AtomType.STRING, AtomType.STRING, AtomType.ITEM), QueryText.REST_URI, false),
    _REST_HEADER_PARAM("header-param(name,variable[,defaults...])", Annotation.params(AtomType.STRING, AtomType.STRING, AtomType.ITEM), QueryText.REST_URI, false),
    _REST_COOKIE_PARAM("cookie-param(name,variable[,defaults...])", Annotation.params(AtomType.STRING, AtomType.STRING, AtomType.ITEM), QueryText.REST_URI, false),
    _REST_ERROR_PARAM("error-param(name,variable[,defaults...])", Annotation.params(AtomType.STRING, AtomType.STRING, AtomType.ITEM), QueryText.REST_URI, false),
    _REST_METHOD("method(name[,body])", Annotation.params(AtomType.STRING, AtomType.STRING), QueryText.REST_URI, false),
    _REST_SINGLE("single([key])", Annotation.params(AtomType.STRING), QueryText.REST_URI),
    _REST_GET("GET()", Annotation.params(new AtomType[0]), QueryText.REST_URI),
    _REST_POST("POST([body])", Annotation.params(AtomType.STRING), QueryText.REST_URI),
    _REST_PUT("PUT([body])", Annotation.params(AtomType.STRING), QueryText.REST_URI),
    _REST_DELETE("DELETE()", Annotation.params(new AtomType[0]), QueryText.REST_URI),
    _REST_HEAD("HEAD()", Annotation.params(new AtomType[0]), QueryText.REST_URI),
    _REST_OPTIONS("OPTIONS()", Annotation.params(new AtomType[0]), QueryText.REST_URI),
    _REST_PATCH("PATCH([body])", Annotation.params(AtomType.STRING), QueryText.REST_URI),
    _UNIT_AFTER("after([function])", Annotation.params(AtomType.STRING), QueryText.UNIT_URI),
    _UNIT_AFTER_MODULE("after-module()", Annotation.params(new AtomType[0]), QueryText.UNIT_URI),
    _UNIT_BEFORE("before([function])", Annotation.params(AtomType.STRING), QueryText.UNIT_URI),
    _UNIT_BEFORE_MODULE("before-module()", Annotation.params(new AtomType[0]), QueryText.UNIT_URI),
    _UNIT_IGNORE("ignore([message])", Annotation.params(AtomType.STRING), QueryText.UNIT_URI),
    _UNIT_TEST("test(['expected',error])", Annotation.params(AtomType.STRING, AtomType.STRING), QueryText.UNIT_URI),
    _WS_CONNECT("connect(path)", Annotation.params(AtomType.STRING), QueryText.WS_URI),
    _WS_MESSAGE("message(path,message)", Annotation.params(AtomType.STRING, AtomType.STRING), QueryText.WS_URI),
    _WS_CLOSE("close(path)", Annotation.params(AtomType.STRING), QueryText.WS_URI),
    _WS_HEADER_PARAM("header-param(name,variable[,defaults...])", Annotation.params(AtomType.STRING, AtomType.STRING, AtomType.ITEM), QueryText.WS_URI, false),
    _WS_ERROR("error(path,message)", Annotation.params(AtomType.STRING, AtomType.STRING), QueryText.WS_URI);

    public final AtomType[] params;
    public final QNm name;
    public final int[] minMax;
    public final boolean single;
    private final String paramString;
    private static final QNmMap<Annotation> MAP;

    private Annotation(String desc, AtomType[] params, byte[] uri) {
        this(desc, params, uri, true);
    }

    private Annotation(String string2, AtomType[] params, byte[] uri, boolean single) {
        this.params = params;
        this.single = single;
        int s = string2.indexOf(40);
        this.name = new QNm(NSGlobal.prefix(uri), Token.token(string2.substring(0, s)), uri);
        this.paramString = string2.substring(s + 1).replace(")", "");
        this.minMax = FuncDefinition.minMax(this.paramString);
    }

    public static Annotation get(QNm name) {
        return MAP.get(name);
    }

    private static AtomType[] params(AtomType ... params) {
        return params;
    }

    public String toString() {
        return Strings.concat(this.name.string(), this.paramString.isEmpty() ? "" : "(" + this.paramString + ")");
    }

    static {
        MAP = new QNmMap();
        for (Annotation value : Annotation.values()) {
            MAP.put(value.name, value);
        }
    }
}

