/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CAttr;
import org.basex.query.expr.constr.CComm;
import org.basex.query.expr.constr.CPI;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public abstract class CNode
extends Arr {
    final boolean computed;

    CNode(InputInfo info, SeqType seqType, boolean computed, Expr ... exprs) {
        super(info, seqType, exprs);
        this.computed = computed;
    }

    @Override
    public abstract Item item(QueryContext var1, InputInfo var2) throws QueryException;

    final void optValue(CompileContext cc) throws QueryException {
        this.exprs = this.simplifyAll(CompileContext.Simplify.STRING, cc);
        if (this.values(true, cc) && (this.exprs.length != 1 || !(this.exprs[0] instanceof Str))) {
            this.exprs = new Expr[]{Str.get(this.atomValue(cc.qc, true))};
        }
    }

    final byte[] atomValue(QueryContext qc, boolean empty) throws QueryException {
        TokenBuilder tb = null;
        for (Expr expr : this.exprs) {
            Item item;
            boolean more = false;
            Iter iter = expr.atomIter(qc, this.info);
            while ((item = qc.next(iter)) != null) {
                if (tb == null) {
                    tb = new TokenBuilder();
                } else if (more) {
                    tb.add(32);
                }
                tb.add(item.string(this.info));
                more = true;
            }
        }
        return tb != null ? tb.finish() : (byte[])(empty ? Token.EMPTY : null);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        SeqType st1;
        SeqType st = null;
        if (this.exprs.length == 1 && !(this instanceof CPI) && !(this instanceof CAttr) && (st1 = this.exprs[0].seqType()).zeroOrOne() && st1.instanceOf(Types.ANY_ATOMIC_TYPE_ZO) && !this.has(Flag.NDT)) {
            if (mode == CompileContext.Simplify.STRING) {
                st = Types.STRING_ZO;
            } else if (mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER)) {
                st = this instanceof CComm ? Types.STRING_ZO : Types.UNTYPED_ATOMIC_ZO;
            }
        }
        return cc.simplify(this, st != null ? new Cast(this.info, this.exprs[0], st).optimize(cc) : this, mode);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.CNS.oneOf(flags) || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return !ic.expr.has(Flag.CNS) && super.inlineable(ic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CNode)) return false;
        CNode cnode = (CNode)obj;
        if (this.computed != cnode.computed) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public final String description() {
        return Strings.concat(((NodeType)this.seqType().type).kind(), " constructor");
    }

    protected void toString(QueryString qs, String kind) {
        if (kind != null) {
            qs.token(kind);
        }
        qs.token("{");
        if (this.exprs.length > 0) {
            qs.tokens(this.exprs, ", ", false);
        }
        qs.token(" }");
    }
}

