/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.data.Data;
import org.basex.query.expr.path.NodeTest;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class NameTest
extends Test {
    public final QNm qname;
    public final Scope scope;
    public final byte[] defaultNs;
    public byte[] local;

    public static NameTest get(NodeType type, QNm qname) {
        Scope scope = type == NodeType.PROCESSING_INSTRUCTION ? Scope.LOCAL : Scope.FULL;
        return new NameTest(qname, scope, type, null);
    }

    public static NameTest get(QNm qname) {
        return new NameTest(qname, Scope.FULL, NodeType.ELEMENT, null);
    }

    public NameTest(QNm qname, Scope scope, NodeType type, byte[] defaultNs) {
        super(type);
        this.qname = qname;
        this.scope = scope;
        byte[] byArray = this.defaultNs = defaultNs != null ? defaultNs : Token.EMPTY;
        if (scope == Scope.LOCAL) {
            this.local = qname.local();
        }
    }

    @Override
    public Test optimize(Data data) {
        if (data == null) {
            return this;
        }
        byte[] dataNs = data.defaultNs();
        if (dataNs == null) {
            return this;
        }
        if (this.scope == Scope.FULL && !this.qname.hasURI()) {
            if (this.type != NodeType.ATTRIBUTE && !Token.eq(dataNs, this.defaultNs)) {
                return null;
            }
            this.local = this.qname.local();
        }
        if (this.type != NodeType.PROCESSING_INSTRUCTION && this.local != null && !(this.type == NodeType.ELEMENT ? data.elemNames : data.attrNames).contains(this.local)) {
            return null;
        }
        return this;
    }

    @Override
    public Test copy() {
        return this;
    }

    @Override
    public boolean matches(ANode node) {
        return node.type == this.type && (this.local != null ? Token.eq(this.local, Token.local(node.name())) : (this.scope == Scope.URI ? Token.eq(this.qname.uri(), node.qname().uri()) : this.qname.eq(node.qname())));
    }

    public boolean matches(QNm qName) {
        return this.local != null ? Token.eq(this.local, qName.local()) : (this.scope == Scope.URI ? Token.eq(this.qname.uri(), qName.uri()) : this.qname.eq(qName));
    }

    @Override
    public Boolean matches(SeqType seqType) {
        Test test;
        Type tp = seqType.type;
        if (tp.intersect(this.type) == null) {
            return Boolean.FALSE;
        }
        if (tp == this.type && (test = seqType.test()) instanceof NameTest) {
            NameTest nt = (NameTest)test;
            if (nt.scope == this.scope || nt.scope == Scope.FULL) {
                return this.matches(nt.qname);
            }
        }
        return null;
    }

    @Override
    public boolean instanceOf(Test test) {
        block7: {
            boolean bl;
            block9: {
                block8: {
                    if (!(test instanceof NameTest)) break block7;
                    NameTest nt = (NameTest)test;
                    if (this.type != nt.type) break block8;
                    switch (nt.scope) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case LOCAL: {
                            if ((this.scope == Scope.LOCAL || this.scope == Scope.FULL) && Token.eq(this.qname.local(), nt.qname.local())) {
                                break;
                            }
                            break block8;
                        }
                        case URI: {
                            if ((this.scope == Scope.URI || this.scope == Scope.FULL) && Token.eq(this.qname.uri(), nt.qname.uri())) {
                                break;
                            }
                            break block8;
                        }
                        case FULL: {
                            if (this.scope != Scope.FULL || !this.qname.eq(nt.qname)) break block8;
                        }
                    }
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            return bl;
        }
        return super.instanceOf(test);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Test intersect(Test test) {
        if (test instanceof NameTest) {
            NameTest nt = (NameTest)test;
            if (this.type != nt.type) return null;
            if (this.scope == nt.scope || this.scope == Scope.FULL) {
                if (!nt.matches(this.qname)) return null;
                return this;
            }
            if (nt.scope != Scope.URI) return test.intersect(this);
            return new NameTest(new QNm(this.local, nt.qname.uri()), Scope.FULL, this.type, this.defaultNs);
        }
        if (test instanceof NodeTest) {
            if (!this.type.instanceOf(test.type)) return null;
            return this;
        }
        if (!(test instanceof UnionTest)) return null;
        return test.intersect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof NameTest)) return false;
        NameTest nt = (NameTest)obj;
        if (this.type != nt.type) return false;
        if (this.scope != nt.scope) return false;
        if (!this.qname.eq(nt.qname)) return false;
        return true;
    }

    @Override
    public String toString(boolean full) {
        boolean pi = this.type == NodeType.PROCESSING_INSTRUCTION;
        TokenBuilder tb = new TokenBuilder();
        byte[] p = this.qname.prefix();
        byte[] u = this.qname.uri();
        byte[] l = this.qname.local();
        if (this.scope == Scope.LOCAL && !pi) {
            if (!full || this.type != NodeType.ATTRIBUTE) {
                tb.add("*:");
            }
        } else if (p.length > 0) {
            tb.add(p).add(58);
        } else if (u.length != 0) {
            tb.add("Q{").add(u).add(125);
        }
        if (this.scope == Scope.URI) {
            tb.add(42);
        } else {
            tb.add(l);
        }
        String test = tb.toString();
        return full || pi ? this.type.toString(test) : test;
    }

    public static enum Scope {
        LOCAL,
        URI,
        FULL;

    }
}

