/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.hash;

import java.util.function.Supplier;
import org.basex.query.QueryException;
import org.basex.query.util.hash.HashItemSet;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.value.item.Item;
import org.basex.util.Array;

public final class ItemObjectMap<E>
extends HashItemSet {
    private Object[] values = new Object[this.capacity()];

    public ItemObjectMap() {
        this(2L);
    }

    public ItemObjectMap(long capacity) {
        super(ItemSet.Mode.ATOMIC, null, capacity);
    }

    public E value(int index) {
        return (E)this.values[index];
    }

    public void value(int index, E value) {
        this.values[index] = value;
    }

    public E put(Item key, E value) throws QueryException {
        int i = this.put(key);
        Object v = this.values[i];
        this.values[i] = value;
        return (E)v;
    }

    public E computeIfAbsent(Item key, Supplier<? extends E> func) throws QueryException {
        E value = this.get(key);
        if (value == null) {
            value = func.get();
            this.put(key, value);
        }
        return value;
    }

    public E get(Item key) throws QueryException {
        return (E)this.values[this.index(key)];
    }

    @Override
    protected void rehash(int newSize) {
        super.rehash(newSize);
        this.values = Array.copy(this.values, new Object[newSize]);
    }

    @Override
    public String toString() {
        return this.toString(this.keys, this.values);
    }
}

