/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.basex.util.Util;

final class ClassLoaderCache {
    private static final ClassLoader LOADER = ClassLoaderCache.class.getClassLoader();
    private static final ConcurrentHashMap<List<String>, Loader> CACHE = new ConcurrentHashMap();

    private ClassLoaderCache() {
    }

    static Loader acquire(List<String> fileUrls) throws IOException {
        List<String> keys = ClassLoaderCache.normalize(fileUrls);
        int n = keys.size();
        URL[] urls = new URL[n];
        long[] lastModified = new long[n];
        try {
            int i = 0;
            for (String key : keys) {
                URL url = new URL(key);
                if (!"file".equals(url.getProtocol())) {
                    throw Util.notExpected();
                }
                lastModified[i] = Files.getLastModifiedTime(Paths.get(url.toURI()), new LinkOption[0]).toMillis();
                urls[i++] = url;
            }
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
        return CACHE.compute(keys, (k, v) -> {
            if (v != null) {
                if (Arrays.equals(v.lastModified, lastModified)) {
                    v.refs.incrementAndGet();
                    return v;
                }
                v.invalidate();
            }
            return new Loader(new URLClassLoader(urls, LOADER), lastModified);
        });
    }

    static void invalidate(List<String> fileUrls) {
        Loader loader = CACHE.remove(ClassLoaderCache.normalize(fileUrls));
        if (loader != null) {
            loader.invalidate();
        }
    }

    private static List<String> normalize(List<String> strings) {
        ArrayList<String> normalized = new ArrayList<String>(strings);
        normalized.sort(String::compareTo);
        return normalized;
    }

    static final class Loader {
        private final URLClassLoader loader;
        private final long[] lastModified;
        private final AtomicInteger refs = new AtomicInteger(1);
        private final Map<String, Class<?>> classes = new ConcurrentHashMap();
        private volatile boolean stale;

        private Loader(URLClassLoader loader, long[] lastModified) {
            this.loader = loader;
            this.lastModified = lastModified;
        }

        Class<?> find(String name) {
            Class<?> cached = this.classes.get(name);
            if (cached != null) {
                return cached;
            }
            try {
                Class<?> c = Class.forName(name, true, this.loader);
                this.classes.putIfAbsent(name, c);
                return c;
            }
            catch (ClassNotFoundException ex) {
                Util.debug(ex);
                return null;
            }
        }

        void release() {
            if (this.refs.decrementAndGet() == 0 && this.stale) {
                this.close();
            }
        }

        private void invalidate() {
            this.stale = true;
            if (this.refs.get() == 0) {
                this.close();
            }
        }

        private void close() {
            try {
                this.loader.close();
            }
            catch (IOException ex) {
                Util.stack(ex);
            }
            this.classes.clear();
        }
    }
}

