/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public abstract class AStr
extends Item {
    private static final int[] ASCII = new int[0];
    byte[] value;
    private int[] offsets;

    AStr() {
        super(AtomType.STRING);
    }

    AStr(byte[] value, Type type) {
        super(type);
        this.value = value;
    }

    @Override
    public final boolean bool(InputInfo ii) throws QueryException {
        return this.string(ii).length != 0;
    }

    public boolean ascii(InputInfo info) throws QueryException {
        if (this.offsets == null) {
            int[] off = Token.cpOffsets(this.string(info));
            this.offsets = off == null ? ASCII : off;
        }
        return this.offsets == ASCII;
    }

    public int length(InputInfo info) throws QueryException {
        return this.ascii(info) ? this.string(info).length : this.offsets.length;
    }

    public byte[][] characters(InputInfo info) throws QueryException {
        TokenList list = new TokenList(this.length(info));
        Token.forEachCp(this.string(info), cp -> list.add(Token.cpToken(cp)));
        return (byte[][])list.finish();
    }

    public int[] codepoints(InputInfo info) throws QueryException {
        IntList list = new IntList(this.length(info));
        Token.forEachCp(this.string(info), list::add);
        return list.finish();
    }

    public AStr substring(InputInfo info, int start, int end) throws QueryException {
        int s;
        if (start == 0 && end == this.length(info)) {
            return this;
        }
        byte[] token = this.string(info);
        boolean ascii = this.ascii(info);
        int n = s = ascii ? start : this.offsets[start];
        int e = ascii ? end : (end < this.offsets.length ? this.offsets[end] : token.length);
        return Str.get(Arrays.copyOfRange(token, s, e));
    }

    @Override
    public final boolean comparable(Item item) {
        return item.type.isStringOrUntyped();
    }

    @Override
    public final boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        return this.comparable(item) && Token.eq(this.string(deep.info), item.string(deep.info), deep);
    }

    @Override
    public final int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        return Token.compare(this.string(ii), item.string(ii), Collation.get(coll, ii));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AStr)) {
            return false;
        }
        AStr a = (AStr)obj;
        return this.type == a.type && Token.eq(this.value, a.value);
    }

    @Override
    public void toString(QueryString qs) {
        qs.quoted(this.value);
    }
}

