/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Collection;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.Language;
import org.basex.util.ft.StemDir;
import org.basex.util.ft.Stemmer;

final class DictionaryStemmer
extends Stemmer {
    private final StemDir dict;

    DictionaryStemmer(StemDir dict, FTIterator fti) {
        super(fti);
        this.dict = dict;
    }

    @Override
    Stemmer get(Language lang, FTIterator fti) {
        return new DictionaryStemmer(this.dict, fti);
    }

    @Override
    protected byte prec() {
        return 20;
    }

    @Override
    Collection<Language> languages() {
        return Language.ALL.values();
    }

    @Override
    protected byte[] stem(byte[] word) {
        return this.dict.stem(word);
    }
}

