/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.basex.api.dom.BXDoc;
import org.basex.api.xmldb.BXCollection;
import org.basex.build.Builder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.SAXHandler;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.io.in.ArrayInput;
import org.basex.io.out.ArrayOutput;
import org.basex.io.parse.xml.XmlParser;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public final class BXXMLResource
implements XMLResource {
    private final BXCollection coll;
    private String id;
    private Item item;
    Object content;
    Data data;
    int pre;

    BXXMLResource(byte[] content, BXCollection coll) {
        this.content = content;
        this.coll = coll;
    }

    BXXMLResource(Item item, BXCollection coll) {
        this.item = item;
        this.coll = coll;
    }

    BXXMLResource(Data data, int pre, String id, BXCollection coll) {
        this.id = id;
        this.coll = coll;
        this.data = data;
        this.pre = pre;
    }

    public Collection getParentCollection() {
        return this.coll;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceType() {
        return "XMLResource";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getContent() throws XMLDBException {
        Object object;
        Object object2;
        if (this.content == null) {
            try {
                ArrayOutput ao = new ArrayOutput();
                try (Serializer ser = Serializer.get((OutputStream)ao);){
                    if (this.data != null) {
                        ser.serialize((Item)new DBNode(this.data, this.pre));
                    } else {
                        if (this.item == null) {
                            Object var3_4 = null;
                            return var3_4;
                        }
                        ser.serialize(this.item);
                    }
                }
                this.content = ao.finish();
            }
            catch (IOException ex) {
                throw new XMLDBException(1, ex.getMessage());
            }
        }
        if ((object2 = this.content) instanceof byte[]) {
            byte[] bytes = (byte[])object2;
            object = Token.string((byte[])bytes);
            return object;
        }
        object = this.content;
        return object;
    }

    public void setContent(Object value) throws XMLDBException {
        if (value instanceof byte[]) {
            this.content = value;
        } else if (value instanceof String) {
            String string = (String)value;
            this.content = Token.token((String)string);
        } else if (value instanceof File) {
            File file = (File)value;
            try {
                this.content = new IOFile(file).read();
            }
            catch (IOException ex) {
                throw new XMLDBException(1, "Content cannot be set.\n" + ex.getMessage());
            }
        } else {
            throw new XMLDBException(1, "Content cannot be set.");
        }
    }

    public String getDocumentId() throws XMLDBException {
        if (this.item != null) {
            throw new XMLDBException(1, "Document ID cannot be retrieved from query result.");
        }
        if (this.id != null) {
            return this.id;
        }
        int p = this.pre;
        while (p >= 0) {
            int k = this.data.kind(p);
            if (k == 0) {
                return Token.string((byte[])this.data.text(p, true));
            }
            p = this.data.parent(p, k);
        }
        return null;
    }

    public Node getContentAsDOM() {
        if (!(this.content instanceof Node)) {
            this.content = new BXDoc((ANode)new DBNode(this.data, this.pre));
        }
        return (Node)this.content;
    }

    public void setContentAsDOM(Node cont) throws XMLDBException {
        if (cont == null) {
            throw new XMLDBException(301);
        }
        if (!(cont instanceof Document)) {
            throw new XMLDBException(3);
        }
        this.content = cont;
    }

    public void getContentAsSAX(ContentHandler handler) throws XMLDBException {
        if (handler == null) {
            throw new XMLDBException(301);
        }
        try {
            new XmlParser().contentHandler(handler).parse((InputStream)new ArrayInput(this.getContent().toString()));
        }
        catch (Exception pce) {
            throw new XMLDBException(1, pce.getMessage());
        }
    }

    public ContentHandler setContentAsSAX() {
        MemBuilder builder = new MemBuilder(Parser.emptyParser((MainOptions)this.coll.ctx.options)).init();
        return new BXSAXContentHandler(this, builder);
    }

    private static final class BXSAXContentHandler
    extends SAXHandler {
        private final BXXMLResource resource;

        BXSAXContentHandler(BXXMLResource resource, MemBuilder builder) {
            super((Builder)builder);
            this.resource = resource;
        }

        public void endDocument() throws SAXException {
            try {
                this.resource.content = new DBNode(((MemBuilder)this.builder).data()).serialize().finish();
            }
            catch (QueryIOException ex) {
                throw BXSAXContentHandler.error((IOException)((Object)new BaseXException((Exception)((Object)ex))));
            }
        }
    }
}

