/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.members.ResolvedMember;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class AnnotationHelper {
    private AnnotationHelper() {
    }

    public static <A extends Annotation> Optional<A> resolveAnnotation(ResolvedMember<?> member, Class<A> annotationClass, Predicate<Annotation> metaAnnotationCheck) {
        Annotation annotation = member.getAnnotations().get(annotationClass);
        if (annotation == null) {
            return AnnotationHelper.resolveNestedAnnotations(StreamSupport.stream(member.getAnnotations().spliterator(), false), annotationClass, metaAnnotationCheck);
        }
        return Optional.of(annotation);
    }

    public static <A extends Annotation> Optional<A> resolveAnnotation(List<Annotation> annotationList, Class<A> annotationClass, Predicate<Annotation> metaAnnotationCheck) {
        Optional<Annotation> annotation = annotationList.stream().filter(annotationClass::isInstance).findFirst();
        if (annotation.isPresent()) {
            return annotation.map(annotationClass::cast);
        }
        return AnnotationHelper.resolveNestedAnnotations(annotationList.stream(), annotationClass, metaAnnotationCheck);
    }

    public static <A extends Annotation> Optional<A> resolveAnnotation(AnnotatedElement annotatedElement, Class<A> annotationClass, Predicate<Annotation> metaAnnotationCheck) {
        A annotation = annotatedElement.getAnnotation(annotationClass);
        if (annotation == null) {
            return AnnotationHelper.resolveNestedAnnotations(Arrays.stream(annotatedElement.getAnnotations()), annotationClass, metaAnnotationCheck);
        }
        return Optional.of(annotation);
    }

    private static <A extends Annotation> Optional<A> resolveNestedAnnotations(Stream<Annotation> initialAnnotations, Class<A> annotationClass, Predicate<Annotation> metaAnnotationCheck) {
        List<Annotation> annotations = AnnotationHelper.extractAnnotationsFromMetaAnnotations(initialAnnotations, metaAnnotationCheck);
        while (!annotations.isEmpty()) {
            Optional<Annotation> directAnnotation = annotations.stream().filter(annotationClass::isInstance).findFirst();
            if (directAnnotation.isPresent()) {
                return directAnnotation.map(annotationClass::cast);
            }
            annotations = AnnotationHelper.extractAnnotationsFromMetaAnnotations(annotations.stream(), metaAnnotationCheck);
        }
        return Optional.empty();
    }

    private static List<Annotation> extractAnnotationsFromMetaAnnotations(Stream<Annotation> annotations, Predicate<Annotation> metaAnnotationCheck) {
        return annotations.filter(metaAnnotationCheck).flatMap(a -> Arrays.stream(a.annotationType().getAnnotations())).collect(Collectors.toList());
    }
}

