/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.assemblers.AssemblerUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Archive;
import org.jreleaser.model.api.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JavaAssembler;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.sdk.tool.Upx;
import org.jreleaser.util.FileType;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public class NativeImageAssemblerProcessor
extends AbstractAssemblerProcessor<NativeImageAssembler, org.jreleaser.model.internal.assemble.NativeImageAssembler> {
    private static final String KEY_GRAALVM_VERSION = "GRAALVM_VERSION";

    public NativeImageAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(TemplateContext props) throws AssemblerProcessingException {
        if (!((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getGraal().isActiveAndSelected()) {
            return;
        }
        Path graalPath = ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getGraal().getEffectivePath(this.context, this.assembler);
        SemanticVersion javaVersion = SemanticVersion.of((String)AssemblerUtils.readJavaVersion(graalPath));
        SemanticVersion graalVersion = SemanticVersion.of((String)this.readGraalVersion(graalPath));
        this.context.getLogger().debug(RB.$((String)"assembler.graal.java", (Object[])new Object[0]), new Object[]{javaVersion, graalPath.toAbsolutePath().toString()});
        this.context.getLogger().debug(RB.$((String)"assembler.graal.graal", (Object[])new Object[0]), new Object[]{graalVersion, graalPath.toAbsolutePath().toString()});
        String platform = ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getGraal().getPlatform();
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path jarsDirectory = assembleDirectory.resolve("jars");
        Path universalJarsDirectory = jarsDirectory.resolve("universal");
        this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(universalJarsDirectory)});
        Set<Path> jars = AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, universalJarsDirectory, "");
        Path platformJarsDirectory = jarsDirectory.resolve(platform);
        this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(platformJarsDirectory)});
        jars.addAll(AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, platformJarsDirectory, platform));
        this.installNativeImage(graalPath);
        this.installComponents(graalPath);
        String imageName = ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getResolvedImageName(this.context);
        if (StringUtils.isNotBlank((String)((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getImageNameTransform())) {
            imageName = ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getResolvedImageNameTransform(this.context);
        }
        this.nativeImage(props, assembleDirectory, graalPath, jars, imageName);
    }

    private void installNativeImage(Path graalPath) throws AssemblerProcessingException {
        Path nativeImageExecutable = graalPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "native-image.cmd" : "native-image").toAbsolutePath();
        if (!Files.exists(nativeImageExecutable, new LinkOption[0])) {
            Path guExecutable = graalPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "gu.cmd" : "gu").toAbsolutePath();
            this.context.getLogger().debug(RB.$((String)"assembler.graal.install.native.exec", (Object[])new Object[0]));
            Command cmd = new Command(guExecutable.toString()).arg("install").arg("-n").arg("native-image");
            this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
            this.executeCommand(cmd);
        }
    }

    private void installComponents(Path graalPath) throws AssemblerProcessingException {
        Path guExecutable = graalPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "gu.cmd" : "gu").toAbsolutePath();
        for (String component : ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getComponents()) {
            this.context.getLogger().debug(RB.$((String)"assembler.graal.install.component", (Object[])new Object[]{component}));
            Command cmd = new Command(guExecutable.toString()).arg("install").arg("-n").arg(component);
            this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
            this.executeCommand(cmd);
        }
    }

    private void nativeImage(TemplateContext props, Path assembleDirectory, Path graalPath, Set<Path> jars, String imageName) throws AssemblerProcessingException {
        String platform = ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getGraal().getPlatform();
        String platformReplaced = ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getPlatform().applyReplacements(platform);
        String finalImageName = imageName + "-" + platformReplaced;
        String executable = ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getExecutable();
        if (!((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getArchiving().isEnabled()) {
            executable = finalImageName;
        }
        String executableFileName = executable;
        if (PlatformUtils.isWindows()) {
            executableFileName = executableFileName + FileType.EXE.extension();
        }
        this.context.getLogger().info("- {}", new Object[]{finalImageName});
        Path image = assembleDirectory.resolve(executableFileName).toAbsolutePath();
        try {
            if (Files.exists(image, new LinkOption[0])) {
                Files.deleteIfExists(image);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_image", (Object[])new Object[]{executableFileName}), (Throwable)e);
        }
        ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getArgs().stream().filter(arg -> arg.startsWith("-H:Name")).findFirst().ifPresent(((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getArgs()::remove);
        Path nativeImageExecutable = graalPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "native-image.cmd" : "native-image").toAbsolutePath();
        Command cmd = new Command(nativeImageExecutable.toString(), true).args((Collection)((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getArgs());
        NativeImageAssembler.PlatformCustomizer customizer = ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getResolvedPlatformCustomizer();
        cmd.args((Collection)customizer.getArgs());
        if (StringUtils.isNotBlank((String)((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getJava().getMainModule())) {
            cmd.arg("--module").arg(((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getJava().getMainModule() + "/" + ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getJava().getMainClass());
            cmd.arg("--module-path").arg(jars.stream().map(Path::toAbsolutePath).map(Path::getParent).distinct().map(Path::toString).map(this::maybeQuote).collect(Collectors.joining(File.pathSeparator)));
        } else {
            cmd.arg("-jar").arg(this.maybeQuote(((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getMainJar().getEffectivePath(this.context, this.assembler).toAbsolutePath().toString()));
            if (!jars.isEmpty()) {
                cmd.arg("-cp").arg(jars.stream().map(Path::toAbsolutePath).map(image.getParent()::relativize).map(Path::toString).map(this::maybeQuote).collect(Collectors.joining(File.pathSeparator)));
            }
        }
        cmd.arg("-H:Name=" + executable);
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        this.executeCommand(image.getParent(), cmd);
        if (((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getUpx().isEnabled()) {
            this.upx(image);
        }
        if (!((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getArchiving().isEnabled()) {
            return;
        }
        try {
            Path tempDirectory = Files.createTempDirectory("jreleaser", new FileAttribute[0]);
            Path distDirectory = tempDirectory.resolve(finalImageName);
            Files.createDirectories(distDirectory, new FileAttribute[0]);
            Path binDirectory = distDirectory.resolve("bin");
            Files.createDirectories(binDirectory, new FileAttribute[0]);
            Files.copy(image, binDirectory.resolve(image.getFileName()), new CopyOption[0]);
            FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)this.context.getBasedir(), (Path)distDirectory, path -> path.getFileName().startsWith("LICENSE"));
            this.copyTemplates(this.context, props, distDirectory);
            this.copyArtifacts(this.context, distDirectory, platform, true);
            this.copyFiles(this.context, distDirectory);
            this.copyFileSets(this.context, distDirectory);
            this.generateSwidTag(this.context, distDirectory);
            String str = ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getGraal().getExtraProperties().getOrDefault("archiveFormat", ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getArchiveFormat()).toString();
            Archive.Format archiveFormat = Archive.Format.of((String)str);
            Path imageArchive = assembleDirectory.resolve(finalImageName + "." + archiveFormat.extension());
            FileUtils.packArchive((Path)tempDirectory, (Path)imageArchive, (FileUtils.ArchiveOptions)((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getOptions().toOptions());
            this.context.getLogger().debug("- {}", new Object[]{imageArchive.getFileName()});
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private void upx(Path image) throws AssemblerProcessingException {
        Upx upx = new Upx(this.context.asImmutable(), ((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getUpx().getVersion());
        try {
            if (!upx.setup()) {
                this.context.getLogger().warn(RB.$((String)"tool_unavailable", (Object[])new Object[]{"upx"}));
                return;
            }
        }
        catch (ToolException e) {
            throw new AssemblerProcessingException(e.getMessage(), (Throwable)e);
        }
        ArrayList<String> args = new ArrayList<String>(((org.jreleaser.model.internal.assemble.NativeImageAssembler)this.assembler).getUpx().getArgs());
        args.add(image.getFileName().toString());
        this.context.getLogger().info("  upx {}", new Object[]{image.getFileName().toString()});
        try {
            upx.invoke(image.getParent(), args);
        }
        catch (CommandException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readGraalVersion(Path path) throws AssemblerProcessingException {
        Path release = path.resolve("release");
        if (!Files.exists(release, new LinkOption[0])) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_invalid_graal_release", (Object[])new Object[]{path.toAbsolutePath()}));
        }
        try (InputStream in = Files.newInputStream(release, new OpenOption[0]);){
            Properties props = new Properties();
            props.load(in);
            if (props.containsKey(KEY_GRAALVM_VERSION)) {
                String version = props.getProperty(KEY_GRAALVM_VERSION);
                if (version.startsWith("\"") && version.endsWith("\"")) {
                    String string = version.substring(1, version.length() - 1);
                    return string;
                }
                String string = version;
                return string;
            }
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_invalid_graal_release_file", (Object[])new Object[]{release.toAbsolutePath()}));
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_invalid_graal_release_file", (Object[])new Object[]{release.toAbsolutePath()}), (Throwable)e);
        }
    }
}

