/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.basex.io.IOFile;
import org.basex.io.in.NewlineInput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;

public final class FileReadTextLines
extends FileFn {
    @Override
    public Iter iter(final QueryContext qc) {
        return new Iter(){
            final TokenBuilder tb = new TokenBuilder();
            NewlineInput ni;
            long[] minMax;
            long c;

            @Override
            public Str next() throws QueryException {
                try {
                    if (this.ni == null) {
                        this.minMax = FileReadTextLines.this.minMax(qc);
                        this.ni = FileReadTextLines.this.input(qc);
                        qc.resources.add(this.ni);
                    }
                    while (++this.c < this.minMax[1] && this.ni.readLine(this.tb)) {
                        if (this.c < this.minMax[0]) continue;
                        return Str.get(this.tb.toArray());
                    }
                    qc.resources.remove(this.ni);
                    return null;
                }
                catch (IOException ex) {
                    throw QueryError.FILE_IO_ERROR_X.get(FileReadTextLines.this.info, ex);
                }
            }
        };
    }

    @Override
    public Value eval(QueryContext qc) throws IOException, QueryException {
        TokenBuilder tb = new TokenBuilder();
        TokenList tl = new TokenList();
        long[] minMax = this.minMax(qc);
        try (NewlineInput ni = this.input(qc);){
            for (long c = 1L; c < minMax[1] && ni.readLine(tb); ++c) {
                qc.checkStop();
                if (c < minMax[0]) continue;
                tl.add(tb.toArray());
            }
            Value value = StrSeq.get(tl);
            return value;
        }
    }

    private NewlineInput input(QueryContext qc) throws IOException, QueryException {
        Path path = this.toPath(this.arg(0), qc);
        String encoding = this.toEncodingOrNull(this.arg(1), QueryError.FILE_UNKNOWN_ENCODING_X, qc);
        boolean fallback = this.toBooleanOrFalse(this.arg(2), qc);
        if (!Files.exists(path, new LinkOption[0])) {
            throw QueryError.FILE_NOT_FOUND_X.get(this.info, path.toAbsolutePath());
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw QueryError.FILE_IS_DIR_X.get(this.info, path.toAbsolutePath());
        }
        if (!Files.isReadable(path)) {
            throw QueryError.FILE_ACCESS_X.get(this.info, path.toAbsolutePath());
        }
        return new NewlineInput(new IOFile(path), encoding).validate(!fallback);
    }

    private long[] minMax(QueryContext qc) throws QueryException {
        Long offset = this.toLongOrNull(this.arg(3), qc);
        Long length = this.toLongOrNull(this.arg(4), qc);
        long off = offset != null ? offset : 1L;
        long len = length != null ? length : Long.MAX_VALUE;
        long end = off + len < 0L ? Long.MAX_VALUE : off + len;
        return new long[]{off, end};
    }

    public static Expr opt(StandardFunc func, long start, long length, CompileContext cc) throws QueryException {
        Expr[] args = func.arg(0).args();
        int al = args.length;
        Str encoding = Str.get("UTF-8");
        Bln validate = Bln.FALSE;
        if (al > 1 && !args[1].equals(encoding) || al > 2 && !args[2].equals(validate) || al > 3 && !(args[3] instanceof Itr) || al > 4 && !(args[4] instanceof Itr)) {
            return func;
        }
        long s = al > 3 ? ((Itr)args[3]).itr() - 1L : 0L;
        long l = al > 4 ? ((Itr)args[4]).itr() : Long.MAX_VALUE;
        s += start;
        if (l < Long.MAX_VALUE) {
            l -= start;
        }
        if (length < l) {
            l = length;
        }
        Expr[] newArgs = new Expr[]{args[0], encoding, validate, Itr.get(s + 1L), Itr.get(l)};
        return cc.function(Function._FILE_READ_TEXT_LINES, func.info(), newArgs);
    }
}

