/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.io.in.DataInput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.ItemSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.seq.SubSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public abstract class Seq
extends Value {
    protected long size;

    protected Seq(long size, Type type) {
        super(type);
        this.size = size;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final Item item(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.typeError(this, AtomType.ITEM, ii);
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        Item first = this.itemAt(0L);
        if (first instanceof ANode) {
            return true;
        }
        if (pos == 0L || !(first instanceof ANum)) {
            throw QueryError.testError(this, false, ii);
        }
        for (Item item : this) {
            if (!(item instanceof ANum)) {
                throw QueryError.testError(this, true, ii);
            }
            if (!item.test(qc, ii, pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(this.size){

            @Override
            public Item get(long i) {
                return Seq.this.itemAt(i);
            }

            @Override
            public boolean valueIter() {
                return true;
            }

            @Override
            public Seq value(QueryContext qc, Expr expr) {
                return Seq.this;
            }
        };
    }

    @Override
    public boolean ddo() {
        return false;
    }

    @Override
    protected Value subSeq(long pos, long length, QueryContext qc) {
        qc.checkStop();
        return new SubSeq(this, pos, length);
    }

    @Override
    public Value insertValue(long pos, Value value, QueryContext qc) {
        return this.toTree(qc).insertValue(pos, value, qc);
    }

    @Override
    public Value removeItem(long pos, QueryContext qc) {
        return this.toTree(qc).removeItem(pos, qc);
    }

    private Value toTree(QueryContext qc) {
        ValueBuilder vb = new ValueBuilder(qc, Long.MIN_VALUE);
        for (Item item : this) {
            vb.add(item);
        }
        return vb.value(this.type);
    }

    @Override
    public Value reverse(QueryContext qc) {
        ValueBuilder vb = new ValueBuilder(qc, this.size);
        for (long i = this.size - 1L; i >= 0L; --i) {
            vb.add(this.itemAt(i));
        }
        return vb.value(this.type);
    }

    @Override
    public final void refineType(Expr expr) {
        Type tp = expr.seqType().type.intersect(this.type);
        if (tp != null) {
            this.type = tp;
        }
    }

    @Override
    public final SeqType seqType() {
        return this.type.seqType(Occ.ONE_OR_MORE);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc, this.size);
        for (Item item : this) {
            vb.add(item.atomValue(qc, ii));
        }
        return vb.value(AtomType.ANY_ATOMIC_TYPE);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Value expr = this;
        if (this.type instanceof NodeType && mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER, CompileContext.Simplify.STRING)) {
            if (mode == CompileContext.Simplify.STRING) {
                TokenList list = new TokenList(this.size);
                int i = 0;
                while ((long)i < this.size) {
                    list.add(this.itemAt(i).string(null));
                    ++i;
                }
                expr = StrSeq.get(list);
            } else {
                Item[] items = new Item[(int)this.size];
                int i = 0;
                while ((long)i < this.size) {
                    items[i] = Atm.get(this.itemAt(i).string(null));
                    ++i;
                }
                expr = ItemSeq.get(items, (int)this.size, AtomType.UNTYPED_ATOMIC);
            }
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        for (Item item : this) {
            item.cache(lazy, ii);
        }
    }

    @Override
    public Value materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        if (this.materialized(test, ii)) {
            return this;
        }
        ValueBuilder vb = new ValueBuilder(qc, this.size);
        for (Item item : this) {
            vb.add(item.materialize((Predicate)test, ii, qc));
        }
        return vb.value(this.type);
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        if (!this.type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
            for (Item item : this) {
                if (item.materialized(test, ii)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean refineType() {
        boolean same = true;
        if (this.type.refinable()) {
            Type refined = null;
            for (Item item : this) {
                Type tp = item.type;
                if (refined == null) {
                    refined = tp;
                    continue;
                }
                same &= refined.eq(tp);
                if (!(refined = refined.union(tp)).eq(this.type)) continue;
                return same;
            }
            this.type = refined;
        }
        return same;
    }

    @Override
    protected final Value rebuild(QueryContext qc) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc, this.size());
        for (Item item : this) {
            vb.add(item.shrink(qc));
        }
        return vb.value(this.type);
    }

    @Override
    public Object toJava() throws QueryException {
        this.refineType();
        int sz = (int)this.size;
        if (this.type == AtomType.STRING) {
            StringList list = new StringList(sz);
            for (Item item : this) {
                list.add(item.string(null));
            }
            return list.finish();
        }
        int a = 0;
        Object[] array = new Object[sz];
        for (Item item : this) {
            array[a++] = item.toJava();
        }
        return array;
    }

    @Override
    public boolean equals(Object obj) {
        Item item1;
        Seq s;
        block6: {
            block5: {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof Seq)) break block5;
                s = (Seq)obj;
                if (this.size == s.size) break block6;
            }
            return false;
        }
        BasicIter<Item> iter1 = this.iter();
        BasicIter<Item> iter2 = s.iter();
        while ((item1 = iter1.next()) != null) {
            if (item1.equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String description() {
        return this.type == AtomType.ITEM ? "sequence" : String.valueOf(this.type) + " sequence";
    }

    @Override
    public void toXml(QueryPlan plan) {
        int max = (int)Math.min(this.size, 5L);
        ExprList list = new ExprList(max);
        for (long i = 0L; i < (long)max; ++i) {
            list.add(this.itemAt(i));
        }
        plan.add(plan.create(this, new Object[0]), (ExprInfo[])list.finish());
    }

    @Override
    public final String toErrorString() {
        return this.build(true).toString();
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.build(false).finish());
    }

    private TokenBuilder build(boolean error) {
        TokenBuilder tb = new TokenBuilder().add(40);
        int i = 0;
        while ((long)i < this.size && tb.moreInfo()) {
            if (i > 0) {
                tb.add(", ");
            }
            tb.add(error ? this.itemAt(i).toErrorString() : this.itemAt(i).toString());
            ++i;
        }
        return tb.add(41);
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException, QueryException {
        throw Util.notExpected();
    }

    public static int initialCapacity(long size) throws QueryException {
        if (size > 0x7FFFFFF7L) {
            throw QueryError.MAX_SIZE_X_X.get(null, 0x7FFFFFF7, size);
        }
        return Array.initialCapacity(size);
    }
}

