/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.Preconditions;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

public final class ErrorProneScope {
    private static final Class<?> FILTER_CLASS = ErrorProneScope.getFilterClass();
    private static final Method anyMatch = ErrorProneScope.getImpl("anyMatch", Predicate.class);
    private static final Method getSymbolsByName = ErrorProneScope.getImpl("getSymbolsByName", Name.class, Predicate.class);
    private static final Method getSymbolsByNameLookupKind = ErrorProneScope.getImpl("getSymbolsByName", Name.class, Predicate.class, Scope.LookupKind.class);
    private static final Method getSymbols = ErrorProneScope.getImpl("getSymbols", Predicate.class);
    private static final Method getSymbolsLookupKind = ErrorProneScope.getImpl("getSymbols", Predicate.class, Scope.LookupKind.class);
    private final Scope scope;

    public Iterable<Symbol> getSymbolsByName(Name name, Predicate<Symbol> predicate) {
        return (Iterable)this.invoke(getSymbolsByName, name, this.maybeAsFilter(predicate));
    }

    public Iterable<Symbol> getSymbolsByName(Name name, Predicate<Symbol> predicate, Scope.LookupKind lookupKind) {
        return (Iterable)this.invoke(getSymbolsByNameLookupKind, new Object[]{name, this.maybeAsFilter(predicate), lookupKind});
    }

    public Iterable<Symbol> getSymbols(Predicate<Symbol> predicate) {
        return (Iterable)this.invoke(getSymbols, this.maybeAsFilter(predicate));
    }

    public Iterable<Symbol> getSymbols(Predicate<Symbol> predicate, Scope.LookupKind lookupKind) {
        return (Iterable)this.invoke(getSymbolsLookupKind, new Object[]{this.maybeAsFilter(predicate), lookupKind});
    }

    public boolean anyMatch(Predicate<Symbol> predicate) {
        return (Boolean)this.invoke(anyMatch, this.maybeAsFilter(predicate));
    }

    private static @Nullable Class<?> getFilterClass() {
        if (Runtime.version().feature() >= 17) {
            return null;
        }
        try {
            return Class.forName("com.sun.tools.javac.util.Filter");
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Method getImpl(String name, Class<?> ... parameters) {
        return FILTER_CLASS != null ? ErrorProneScope.getMethodOrDie(Scope.class, name, (Class[])Arrays.stream(parameters).map(p -> p.equals(Predicate.class) ? FILTER_CLASS : p).toArray(Class[]::new)) : ErrorProneScope.getMethodOrDie(Scope.class, name, parameters);
    }

    ErrorProneScope(Scope scope) {
        this.scope = scope;
    }

    private Object invoke(Method method, Object ... args) {
        try {
            return method.invoke((Object)this.scope, args);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private Object maybeAsFilter(final Predicate<Symbol> predicate) {
        if (FILTER_CLASS == null) {
            return predicate;
        }
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{FILTER_CLASS}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                Preconditions.checkState((boolean)method.getName().equals("accepts"));
                return predicate.test((Symbol)args[0]);
            }
        });
    }

    private static Method getMethodOrDie(Class<?> clazz, String name, Class<?> ... parameters) {
        try {
            return clazz.getMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }
}

