/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.guice;

import com.google.auto.common.MoreElements;
import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.guice.AutoValue_AssistedParameters_ConflictResult;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;

@BugPattern(name="GuiceAssistedParameters", summary="A constructor cannot have two @Assisted parameters of the same type unless they are disambiguated with named @Assisted annotations.", severity=BugPattern.SeverityLevel.ERROR)
public class AssistedParameters
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> IS_CONSTRUCTOR_WITH_INJECT_OR_ASSISTED = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.anyOf((Matcher[])new Matcher[]{InjectMatchers.hasInjectAnnotation(), Matchers.hasAnnotation((String)"com.google.inject.assistedinject.AssistedInject")})});
    private static final MultiMatcher<MethodTree, VariableTree> ASSISTED_PARAMETER_MATCHER = Matchers.methodHasParameters((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasAnnotation((String)"com.google.inject.assistedinject.Assisted"));

    public final Description matchMethod(MethodTree constructor, VisitorState state) {
        if (!IS_CONSTRUCTOR_WITH_INJECT_OR_ASSISTED.matches((Tree)constructor, state)) {
            return Description.NO_MATCH;
        }
        MultiMatcher.MultiMatchResult assistedParameters = ASSISTED_PARAMETER_MATCHER.multiMatchResult((Tree)constructor, state);
        if (!assistedParameters.matches()) {
            return Description.NO_MATCH;
        }
        ListMultimap<Type, VariableTree> parametersByType = AssistedParameters.partitionParametersByType((List<VariableTree>)assistedParameters.matchingNodes(), state);
        ArrayList<ConflictResult> conflicts = new ArrayList<ConflictResult>();
        for (Map.Entry typeAndParameters : parametersByType.asMap().entrySet()) {
            Collection parametersForThisType = (Collection)typeAndParameters.getValue();
            if (parametersForThisType.size() < 2) continue;
            ImmutableListMultimap keyForAssistedVariable = Multimaps.index((Iterable)parametersForThisType, AssistedParameters::valueFromAssistedAnnotation);
            for (Map.Entry assistedValueToParameters : Multimaps.asMap((ListMultimap)keyForAssistedVariable).entrySet()) {
                if (((List)assistedValueToParameters.getValue()).size() <= 1) continue;
                conflicts.add(ConflictResult.create((Type)typeAndParameters.getKey(), (String)assistedValueToParameters.getKey(), (ImmutableList<VariableTree>)ImmutableList.copyOf((Collection)((Collection)assistedValueToParameters.getValue()))));
            }
        }
        if (conflicts.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(constructor).setMessage(AssistedParameters.buildErrorMessage(conflicts)).build();
    }

    private static String valueFromAssistedAnnotation(VariableTree variableTree) {
        for (Attribute.Compound c : ASTHelpers.getSymbol((VariableTree)variableTree).getAnnotationMirrors()) {
            Collection<Attribute> valueEntries;
            if (!MoreElements.asType((Element)c.getAnnotationType().asElement()).getQualifiedName().contentEquals("com.google.inject.assistedinject.Assisted") || (valueEntries = c.getElementValues().values()).isEmpty()) continue;
            return ((Attribute)Iterables.getOnlyElement(valueEntries)).getValue().toString();
        }
        return "";
    }

    private static String buildErrorMessage(List<ConflictResult> conflicts) {
        StringBuilder sb = new StringBuilder(" Assisted parameters of the same type need to have distinct values for the @Assisted annotation. There are conflicts between the annotations on this constructor:");
        for (ConflictResult conflict : conflicts) {
            sb.append("\n").append(conflict.type());
            if (!conflict.value().isEmpty()) {
                sb.append(", @Assisted(\"").append(conflict.value()).append("\")");
            }
            sb.append(": ");
            List simpleParameterNames = Lists.transform(conflict.parameters(), t -> t.getName().toString());
            Joiner.on((String)", ").appendTo(sb, (Iterable)simpleParameterNames);
        }
        return sb.toString();
    }

    private static ListMultimap<Type, VariableTree> partitionParametersByType(List<VariableTree> parameters, VisitorState state) {
        Types types = state.getTypes();
        LinkedListMultimap multimap = LinkedListMultimap.create();
        block0: for (VariableTree node : parameters) {
            Type type = types.unboxedTypeOrType(ASTHelpers.getType((Tree)node));
            for (Type existingType : multimap.keySet()) {
                if (!types.isSameType(existingType, type)) continue;
                multimap.put((Object)existingType, (Object)node);
                continue block0;
            }
            multimap.put((Object)type, (Object)node);
        }
        return multimap;
    }

    @AutoValue
    static abstract class ConflictResult {
        ConflictResult() {
        }

        abstract Type type();

        abstract String value();

        abstract ImmutableList<VariableTree> parameters();

        static ConflictResult create(Type t, String v, ImmutableList<VariableTree> p) {
            return new AutoValue_AssistedParameters_ConflictResult(t, v, p);
        }
    }
}

