/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Preconditions;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.Scope;
import org.jspecify.annotations.Nullable;

public class CompoundScope
implements Scope {
    private final Scope scope;
    private final @Nullable Scope base;

    private CompoundScope(Scope scope, @Nullable Scope base) {
        this.scope = (Scope)Preconditions.checkNotNull((Object)scope);
        this.base = base;
    }

    @Override
    public @Nullable LookupResult lookup(LookupKey key) {
        LookupResult result = this.scope.lookup(key);
        if (result != null) {
            return result;
        }
        if (this.base != null) {
            return this.base.lookup(key);
        }
        return null;
    }

    public CompoundScope append(Scope scope) {
        return new CompoundScope(scope, this);
    }

    public static CompoundScope base(Scope scope) {
        return new CompoundScope(scope, null);
    }
}

