/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.util.StringFunction;

public class ClassPoolFeatureNameFunction
implements StringFunction {
    private final ClassPool classPool;
    private final String defaultFeatureName;

    public ClassPoolFeatureNameFunction(ClassPool classPool) {
        this(classPool, null);
    }

    public ClassPoolFeatureNameFunction(ClassPool classPool, String defaultFeatureName) {
        this.classPool = classPool;
        this.defaultFeatureName = defaultFeatureName;
    }

    @Override
    public String transform(String string) {
        Clazz clazz = this.classPool.getClass(string);
        if (clazz == null) {
            return this.defaultFeatureName;
        }
        Set<String> features = clazz.getExtraFeatureNames();
        if (features.size() == 1) {
            return features.iterator().next();
        }
        return this.defaultFeatureName;
    }
}

