/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.PausesProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;
import org.openjdk.jmh.runner.options.IntegerValueConverter;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.Multiset;

public class GCProfiler
implements InternalProfiler {
    private long beforeTime;
    private long beforeGCCount;
    private long beforeGCTime;
    private HotspotAllocationSnapshot beforeAllocated;
    private boolean churnEnabled;
    private boolean allocEnabled;
    private long churnWait;

    @Override
    public String getDescription() {
        return "GC profiling via standard MBeans";
    }

    public GCProfiler(String initLine) throws ProfilerException {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new ProfilerOptionFormatter(PausesProfiler.class.getCanonicalName()));
        ArgumentAcceptingOptionSpec optAllocEnable = parser.accepts("alloc", "Enable GC allocation measurement.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo((Object)true, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec optChurnEnable = parser.accepts("churn", "Enable GC churn measurement.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec optChurnWait = parser.accepts("churnWait", "Time to wait for churn notifications to arrive.").withRequiredArg().withValuesConvertedBy((ValueConverter)IntegerValueConverter.POSITIVE).describedAs("ms").defaultsTo((Object)500, (Object[])new Integer[0]);
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.churnWait = ((Integer)set.valueOf((OptionSpec)optChurnWait)).intValue();
            this.churnEnabled = (Boolean)set.valueOf((OptionSpec)optChurnEnable);
            this.allocEnabled = (Boolean)set.valueOf((OptionSpec)optAllocEnable);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        if (this.churnEnabled && !VMSupport.tryInitChurn()) {
            this.churnEnabled = false;
        }
        if (this.allocEnabled && !VMSupport.tryInitAlloc()) {
            this.allocEnabled = false;
        }
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        if (this.churnEnabled) {
            VMSupport.startChurnProfile();
        }
        long gcTime = 0L;
        long gcCount = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTime += bean.getCollectionTime();
        }
        this.beforeGCCount = gcCount;
        this.beforeGCTime = gcTime;
        if (this.allocEnabled) {
            this.beforeAllocated = VMSupport.getSnapshot();
        }
        this.beforeTime = System.nanoTime();
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iResult) {
        long afterTime = System.nanoTime();
        if (this.churnEnabled) {
            VMSupport.finishChurnProfile(this.churnWait);
        }
        ArrayList<ScalarResult> results = new ArrayList<ScalarResult>();
        long gcTime = 0L;
        long gcCount = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTime += bean.getCollectionTime();
        }
        results.add(new ScalarResult("gc.count", gcCount - this.beforeGCCount, "counts", AggregationPolicy.SUM));
        if (gcCount != this.beforeGCCount || gcTime != this.beforeGCTime) {
            results.add(new ScalarResult("gc.time", gcTime - this.beforeGCTime, "ms", AggregationPolicy.SUM));
        }
        if (this.allocEnabled) {
            if (this.beforeAllocated != null) {
                HotspotAllocationSnapshot newSnapshot = VMSupport.getSnapshot();
                long allocated = newSnapshot.difference(this.beforeAllocated);
                results.add(new ScalarResult("gc.alloc.rate", afterTime != this.beforeTime ? 1.0 * (double)allocated / 1024.0 / 1024.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)(afterTime - this.beforeTime) : Double.NaN, "MB/sec", AggregationPolicy.AVG));
                if (allocated != 0L) {
                    long allOps = iResult.getMetadata().getAllOps();
                    results.add(new ScalarResult("gc.alloc.rate.norm", allOps != 0L ? 1.0 * (double)allocated / (double)allOps : Double.NaN, "B/op", AggregationPolicy.AVG));
                }
            } else {
                results.add(new ScalarResult("gc.alloc.rate", Double.NaN, "MB/sec", AggregationPolicy.AVG));
            }
        }
        if (this.churnEnabled) {
            Multiset<String> churn = VMSupport.getChurn();
            for (String space : churn.keys()) {
                double churnRate = afterTime != this.beforeTime ? 1.0 * (double)churn.count(space) * (double)TimeUnit.SECONDS.toNanos(1L) / (double)(afterTime - this.beforeTime) / 1024.0 / 1024.0 : Double.NaN;
                double churnNorm = 1.0 * (double)churn.count(space) / (double)iResult.getMetadata().getAllOps();
                String spaceName = space.replaceAll(" ", "_");
                results.add(new ScalarResult("gc.churn." + spaceName + "", churnRate, "MB/sec", AggregationPolicy.AVG));
                results.add(new ScalarResult("gc.churn." + spaceName + ".norm", churnNorm, "B/op", AggregationPolicy.AVG));
            }
        }
        return results;
    }

    static class VMSupport {
        private static ThreadMXBean ALLOC_MX_BEAN;
        private static Method ALLOC_MX_BEAN_GETTER_PER_THREAD;
        private static Method ALLOC_MX_BEAN_GETTER_GLOBAL;
        private static NotificationListener LISTENER;
        private static Multiset<String> CHURN;

        VMSupport() {
        }

        private static boolean tryInitAlloc() {
            try {
                Class<?> internalIntf = Class.forName("com.sun.management.ThreadMXBean");
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                if (!internalIntf.isAssignableFrom(bean.getClass())) {
                    Class<?> pmo = Class.forName("java.lang.management.PlatformManagedObject");
                    Method m = ManagementFactory.class.getMethod("getPlatformMXBean", Class.class, pmo);
                    bean = (ThreadMXBean)m.invoke(null, internalIntf);
                    if (bean == null) {
                        throw new UnsupportedOperationException("No way to access private ThreadMXBean");
                    }
                }
                ALLOC_MX_BEAN = bean;
                try {
                    ALLOC_MX_BEAN_GETTER_GLOBAL = internalIntf.getMethod("getTotalThreadAllocatedBytes", new Class[0]);
                    VMSupport.getSnapshot();
                    return true;
                }
                catch (Exception exception) {
                    ALLOC_MX_BEAN_GETTER_PER_THREAD = internalIntf.getMethod("getThreadAllocatedBytes", long[].class);
                    VMSupport.getSnapshot();
                    return true;
                }
            }
            catch (Throwable e) {
                System.out.println("Allocation profiling is not available: " + e.getMessage());
                return false;
            }
        }

        private static boolean tryInitChurn() {
            try {
                for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                    if (bean instanceof NotificationEmitter) continue;
                    throw new UnsupportedOperationException("GarbageCollectorMXBean cannot notify");
                }
                CHURN = new HashMultiset<String>();
                LISTENER = VMSupport.newListener();
                return true;
            }
            catch (Throwable e) {
                System.out.println("Churn profiling is not available: " + e.getMessage());
                return false;
            }
        }

        private static NotificationListener newListener() {
            try {
                Class<?> infoKlass = Class.forName("com.sun.management.GarbageCollectionNotificationInfo");
                Field notifNameField = infoKlass.getField("GARBAGE_COLLECTION_NOTIFICATION");
                Method infoMethod = infoKlass.getMethod("from", CompositeData.class);
                Method getGcInfo = infoKlass.getMethod("getGcInfo", new Class[0]);
                Method getMemoryUsageBeforeGc = getGcInfo.getReturnType().getMethod("getMemoryUsageBeforeGc", new Class[0]);
                Method getMemoryUsageAfterGc = getGcInfo.getReturnType().getMethod("getMemoryUsageAfterGc", new Class[0]);
                return (n, o) -> {
                    try {
                        if (n.getType().equals(notifNameField.get(null))) {
                            Object info = infoMethod.invoke(null, n.getUserData());
                            Object gcInfo = getGcInfo.invoke(info, new Object[0]);
                            Map mapBefore = (Map)getMemoryUsageBeforeGc.invoke(gcInfo, new Object[0]);
                            Map mapAfter = (Map)getMemoryUsageAfterGc.invoke(gcInfo, new Object[0]);
                            for (Map.Entry entry : mapAfter.entrySet()) {
                                String name = (String)entry.getKey();
                                MemoryUsage after = (MemoryUsage)entry.getValue();
                                MemoryUsage before = (MemoryUsage)mapBefore.get(name);
                                long c = before.getUsed() - after.getUsed();
                                if (c <= 0L) continue;
                                CHURN.add(name, c);
                            }
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                };
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }

        public static HotspotAllocationSnapshot getSnapshot() {
            if (ALLOC_MX_BEAN_GETTER_GLOBAL != null) {
                try {
                    long allocatedBytes = (Long)ALLOC_MX_BEAN_GETTER_GLOBAL.invoke((Object)ALLOC_MX_BEAN, new Object[0]);
                    if (allocatedBytes == -1L) {
                        throw new IllegalStateException("getTotalThreadAllocatedBytes is disabled");
                    }
                    return new GlobalHotspotAllocationSnapshot(allocatedBytes);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
            long[] threadIds = ALLOC_MX_BEAN.getAllThreadIds();
            try {
                long[] allocatedBytes = (long[])ALLOC_MX_BEAN_GETTER_PER_THREAD.invoke((Object)ALLOC_MX_BEAN, new Object[]{threadIds});
                return new PerThreadHotspotAllocationSnapshot(threadIds, allocatedBytes);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public static synchronized void startChurnProfile() {
            CHURN.clear();
            try {
                for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                    ((NotificationEmitter)((Object)bean)).addNotificationListener(LISTENER, null, null);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Should not be here");
            }
        }

        public static synchronized void finishChurnProfile(long churnWait) {
            try {
                Thread.sleep(churnWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                try {
                    ((NotificationEmitter)((Object)bean)).removeNotificationListener(LISTENER);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {}
            }
        }

        public static synchronized Multiset<String> getChurn() {
            return CHURN != null ? CHURN : new HashMultiset();
        }
    }

    static interface HotspotAllocationSnapshot {
        public long difference(HotspotAllocationSnapshot var1);
    }

    static class PerThreadHotspotAllocationSnapshot
    implements HotspotAllocationSnapshot {
        private final long[] threadIds;
        private final long[] allocatedBytes;

        private PerThreadHotspotAllocationSnapshot(long[] threadIds, long[] allocatedBytes) {
            this.threadIds = threadIds;
            this.allocatedBytes = allocatedBytes;
        }

        @Override
        public long difference(HotspotAllocationSnapshot before) {
            if (!(before instanceof PerThreadHotspotAllocationSnapshot)) {
                throw new IllegalArgumentException();
            }
            PerThreadHotspotAllocationSnapshot other = (PerThreadHotspotAllocationSnapshot)before;
            HashMap<Long, Integer> prevIndex = new HashMap<Long, Integer>();
            for (int i = 0; i < other.threadIds.length; ++i) {
                long id = other.threadIds[i];
                prevIndex.put(id, i);
            }
            long currentThreadId = Thread.currentThread().getId();
            long allocated = 0L;
            for (int i = 0; i < this.threadIds.length; ++i) {
                long id = this.threadIds[i];
                if (id == currentThreadId) continue;
                allocated += this.allocatedBytes[i];
                Integer prev = (Integer)prevIndex.get(id);
                if (prev == null) continue;
                allocated -= other.allocatedBytes[prev];
            }
            return allocated;
        }
    }

    static class GlobalHotspotAllocationSnapshot
    implements HotspotAllocationSnapshot {
        private final long allocatedBytes;

        public GlobalHotspotAllocationSnapshot(long allocatedBytes) {
            this.allocatedBytes = allocatedBytes;
        }

        @Override
        public long difference(HotspotAllocationSnapshot before) {
            if (!(before instanceof GlobalHotspotAllocationSnapshot)) {
                throw new IllegalArgumentException();
            }
            GlobalHotspotAllocationSnapshot other = (GlobalHotspotAllocationSnapshot)before;
            long beforeAllocs = other.allocatedBytes;
            if (this.allocatedBytes >= beforeAllocs) {
                return this.allocatedBytes - beforeAllocs;
            }
            return 0L;
        }
    }
}

