/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.inject.Inject;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

final class InstantTypeAdapter
extends TypeAdapter<Instant> {
    @Inject
    InstantTypeAdapter() {
    }

    public void write(JsonWriter out, Instant value) throws IOException {
        out.value(ISODateTimeFormat.dateTime().print((ReadableInstant)value));
    }

    public Instant read(JsonReader in) throws IOException {
        return ISODateTimeFormat.dateTime().parseDateTime(in.nextString()).toInstant();
    }
}

