/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.builder;

import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.cfg.builder.ExtendedNode;
import org.checkerframework.errorprone.dataflow.cfg.builder.Label;

public class ConditionalJump
extends ExtendedNode {
    protected final Label trueSucc;
    protected final Label falseSucc;
    protected Store.FlowRule trueFlowRule;
    protected Store.FlowRule falseFlowRule;

    public ConditionalJump(Label trueSucc, Label falseSucc) {
        super(ExtendedNode.ExtendedNodeType.CONDITIONAL_JUMP);
        assert (trueSucc != null);
        this.trueSucc = trueSucc;
        assert (falseSucc != null);
        this.falseSucc = falseSucc;
    }

    public Label getThenLabel() {
        return this.trueSucc;
    }

    public Label getElseLabel() {
        return this.falseSucc;
    }

    public Store.FlowRule getTrueFlowRule() {
        return this.trueFlowRule;
    }

    public Store.FlowRule getFalseFlowRule() {
        return this.falseFlowRule;
    }

    public void setTrueFlowRule(Store.FlowRule rule) {
        this.trueFlowRule = rule;
    }

    public void setFalseFlowRule(Store.FlowRule rule) {
        this.falseFlowRule = rule;
    }

    @Override
    public String toString() {
        return "TwoTargetConditionalJump(" + this.getThenLabel() + ", " + this.getElseLabel() + ")";
    }

    @Override
    public String toStringDebug() {
        return this.toString();
    }
}

