/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Preconditions;
import groovy.util.Node;
import java.util.Objects;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.FileReference;

public class ProjectDependency
extends AbstractClasspathEntry {
    private FileReference publication;
    private FileReference publicationSourcePath;
    private FileReference publicationJavadocPath;
    private DefaultTaskDependency buildDependencies = new DefaultTaskDependency();

    public ProjectDependency(Node node) {
        super(node);
        this.assertPathIsValid();
    }

    public ProjectDependency(String path) {
        super(path);
        this.assertPathIsValid();
    }

    public FileReference getPublication() {
        return this.publication;
    }

    public void setPublication(FileReference publication) {
        this.publication = publication;
    }

    public FileReference getPublicationSourcePath() {
        return this.publicationSourcePath;
    }

    public void setPublicationSourcePath(FileReference publicationSourcePath) {
        this.publicationSourcePath = publicationSourcePath;
    }

    public FileReference getPublicationJavadocPath() {
        return this.publicationJavadocPath;
    }

    public void setPublicationJavadocPath(FileReference publicationJavadocPath) {
        this.publicationJavadocPath = publicationJavadocPath;
    }

    public TaskDependency getBuildDependencies() {
        return this.buildDependencies;
    }

    public void buildDependencies(Object ... buildDependencies) {
        this.buildDependencies.add(buildDependencies);
    }

    private void assertPathIsValid() {
        Preconditions.checkArgument((boolean)this.path.startsWith("/"));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectDependency that = (ProjectDependency)o;
        return Objects.equals(this.publication, that.publication) && Objects.equals(this.publicationSourcePath, that.publicationSourcePath) && Objects.equals(this.publicationJavadocPath, that.publicationJavadocPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.publication, this.publicationSourcePath, this.publicationJavadocPath);
    }

    @Override
    public String getKind() {
        return "src";
    }

    @Override
    public String toString() {
        return "ProjectDependency{publication=" + this.publication + ", publicationSourcePath=" + this.publicationSourcePath + ", publicationJavadocPath=" + this.publicationJavadocPath + ", buildDependencies=" + this.buildDependencies + ", path='" + this.path + '\'' + ", exported=" + this.exported + ", accessRules=" + this.accessRules + ", entryAttributes=" + this.entryAttributes + '}';
    }
}

