/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.junit.result.AggregateTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.BinaryResultBackedTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.HtmlTestReport;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class LegacyTestReportGenerator
implements TestReportGenerator {
    private final Supplier<TestResultsProvider> provider;

    private static Supplier<TestResultsProvider> createAggregateProvider(FileCollection resultDirs) {
        if (resultDirs.getFiles().size() == 1) {
            File singleFile = resultDirs.getSingleFile();
            return () -> new BinaryResultBackedTestResultsProvider(singleFile);
        }
        Set dirs = resultDirs.getFiles();
        return () -> {
            LinkedList resultsProviders = new LinkedList();
            try {
                return new AggregateTestResultsProvider((Iterable)CollectionUtils.collect((Iterable)dirs, resultsProviders, BinaryResultBackedTestResultsProvider::new));
            }
            catch (RuntimeException e) {
                CompositeStoppable.stoppable(resultsProviders).stop();
                throw e;
            }
        };
    }

    public LegacyTestReportGenerator(FileCollection resultDirs) {
        this.provider = LegacyTestReportGenerator.createAggregateProvider(resultDirs);
    }

    public boolean hasResults() {
        boolean bl;
        block8: {
            TestResultsProvider provider = this.provider.get();
            try {
                bl = provider.isHasResults();
                if (provider == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (provider != null) {
                        try {
                            provider.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not determine if there are test results", e);
                }
            }
            provider.close();
        }
        return bl;
    }

    public void generateReport(BuildOperationRunner operationRunner, BuildOperationExecutor operationExecutor, Path outputDir) {
        HtmlTestReport testReport = new HtmlTestReport(operationRunner, operationExecutor);
        try (TestResultsProvider provider = this.provider.get();){
            testReport.generateReport(provider, outputDir.toFile());
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

