/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.HtmlPageBuilder;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.GradleVersion;

public abstract class TabbedPageRenderer<T>
extends ReportRenderer<T, HtmlPageBuilder<SimpleHtmlWriter>> {
    private static final URL BASE_STYLE_URL = TabbedPageRenderer.class.getResource("/org/gradle/reporting/base-style.css");
    private static final URL REPORT_JS_URL = TabbedPageRenderer.class.getResource("/org/gradle/reporting/report.js");
    private T model;

    protected T getModel() {
        return this.model;
    }

    protected abstract String getTitle();

    protected abstract ReportRenderer<T, SimpleHtmlWriter> getHeaderRenderer();

    protected abstract ReportRenderer<T, SimpleHtmlWriter> getContentRenderer();

    protected String getPageTitle() {
        return this.getTitle();
    }

    protected abstract URL getStyleUrl();

    @Override
    public void render(T model, HtmlPageBuilder<SimpleHtmlWriter> builder) throws IOException {
        this.model = model;
        String title = this.getTitle();
        String baseStyleLink = builder.requireResource(BASE_STYLE_URL);
        String reportJsLink = builder.requireResource(REPORT_JS_URL);
        String styleLink = builder.requireResource(this.getStyleUrl());
        SimpleHtmlWriter htmlWriter = builder.getOutput();
        htmlWriter.startElement("head").startElement("meta").attribute("http-equiv", "Content-Type").attribute("content", "text/html; charset=utf-8").endElement().startElement("meta").attribute("http-equiv", "x-ua-compatible").attribute("content", "IE=edge").endElement().startElement("title").characters((CharSequence)this.getPageTitle()).endElement().startElement("link").attribute("href", baseStyleLink).attribute("rel", "stylesheet").attribute("type", "text/css").endElement().startElement("link").attribute("href", styleLink).attribute("rel", "stylesheet").attribute("type", "text/css").endElement().startElement("script").attribute("src", reportJsLink).attribute("type", "text/javascript").characters((CharSequence)"").endElement().endElement();
        htmlWriter.startElement("body").startElement("div").attribute("id", "content");
        if (!title.isEmpty()) {
            htmlWriter.startElement("h1").characters((CharSequence)title).endElement();
        }
        this.getHeaderRenderer().render(model, htmlWriter);
        this.getContentRenderer().render(model, htmlWriter);
        htmlWriter.startElement("div").attribute("id", "footer").startElement("p").startElement("div").startElement("label").attribute("class", "hidden").attribute("id", "label-for-line-wrapping-toggle").attribute("for", "line-wrapping-toggle").characters((CharSequence)"Wrap lines").startElement("input").attribute("id", "line-wrapping-toggle").attribute("type", "checkbox").attribute("autocomplete", "off").endElement().endElement().endElement().characters((CharSequence)"Generated by ").startElement("a").attribute("href", "https://www.gradle.org").characters((CharSequence)("Gradle " + GradleVersion.current().getVersion())).endElement().characters((CharSequence)String.format(" at %s", builder.formatDate(new Date()))).endElement().endElement().endElement().endElement();
    }
}

