/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public interface Deferrable<T> {
    public Optional<T> getCompleted();

    public T completeAndGet();

    default public <U> Deferrable<U> map(final Function<? super T, U> mapper) {
        return new Deferrable<U>(){

            @Override
            public Optional<U> getCompleted() {
                return Deferrable.this.getCompleted().map((? super T value) -> this.applyAndRequireNonNull(value, mapper));
            }

            @Override
            public U completeAndGet() {
                return this.applyAndRequireNonNull(Deferrable.this.completeAndGet(), mapper);
            }

            private U applyAndRequireNonNull(T value, Function<? super T, U> mapper2) {
                Object result = mapper2.apply(value);
                return Objects.requireNonNull(result, "Mapping a Deferrable to null is not allowed");
            }
        };
    }

    default public <U> Deferrable<U> flatMap(Function<? super T, Deferrable<U>> mapper) {
        return this.getCompleted().map(mapper).orElseGet(() -> Deferrable.deferred(() -> ((Deferrable)mapper.apply((T)this.completeAndGet())).completeAndGet()));
    }

    public static <T> Deferrable<T> completed(final T successfulResult) {
        return new Deferrable<T>(){

            @Override
            public Optional<T> getCompleted() {
                return Optional.of(successfulResult);
            }

            @Override
            public T completeAndGet() {
                return successfulResult;
            }
        };
    }

    public static <T> Deferrable<T> deferred(final Supplier<T> result) {
        return new Deferrable<T>(){
            private volatile @Nullable T value;

            @Override
            public Optional<T> getCompleted() {
                return Optional.ofNullable(this.value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T completeAndGet() {
                if (this.value == null) {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.value == null) {
                            this.value = result.get();
                        }
                    }
                }
                return this.value;
            }
        };
    }
}

